
(* 2x1 flyways 2 xbots (actual physical) - ZoneCtrl, FenceCtrl, GetStatus *)
FUNCTION_BLOCK Example28b_zoneloading
	IF NOT(Execute) THEN
		UserFinishedAddingXbot := FALSE;
	END_IF; 

	(*move xbot 1 to side*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := Execute,cmdLB := 1,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.06,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*deactivate zone 2 (flyway 2)*)
	PMC_Zone_ZoneCtrl1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,ZoneID := 2,Level := 0);

	(*tell user that they can now put the xbot into the zone*)
	UserCanAddXbot := PMC_Zone_ZoneCtrl1.Done;

	(*activate zone once user says they are done adding the xbot*)
	PMC_Zone_ZoneCtrl2(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := UserFinishedAddingXbot AND PMC_Zone_ZoneCtrl1.Done,ZoneID := 2,Level := 1);

	(*read zone info*)
	PMC_Zone_GetStatus1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := PMC_Zone_ZoneCtrl2.Done,ZoneID := 2);

	(*turn off fence on zone 2*)
	PMC_Zone_Fencing1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := PMC_Zone_GetStatus1.Done,ZoneID := 2,Level := 0);

	(*move xbot in zone 2 to side*)
	PMC_XYMotion2(PM_Controller := PM_Controller,Execute := PMC_Zone_Fencing1.Done,cmdLB := 8,XbotID := PMC_Zone_GetStatus1.XbotIDs[0],Mode := 0,Type_ := 2,PosX := 0.06,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	Done := PMC_XYMotion2.Done;
END_FUNCTION_BLOCK
